<?php

namespace App\Http\Controllers;
use App\Http\Models\Post;

class PageHome extends Controller
{
    public $content;
    /**
     * Show the Home page.
     */
    public function index()
    {
        $post_id = get_the_ID();
        $this->content['hero'] = get_field('hero');
        $this->content['design'] = get_field('design');
        $this->content['spaces'] = get_field('spaces');
        $this->content['floorplans'] = get_field('floorplans');
        $this->content['masterplan'] = get_field('masterplan');
        $this->content['udpates'] = get_field('latest_updates');
        $this->content['post_id'] = get_field('latest_updates_post');
        $this->content['latest_post'] = (new Post)->get_posts(get_field('latest_updates_post'));
        $this->content['location'] = get_field('location');
        $this->content['community'] = get_field('business');
        $this->content['community_video'] = get_field('business_video_url', false, false);
        $this->content['delivery'] = get_field('delivery');
        $this->content['cta'] = get_field('cta');

        return view('templates.page-home', $this->content);
    }
}