<?php

namespace App\Http\Controllers;

use Illuminate\Routing\Controller as BaseController;
use Themosis\Core\Forms\FormHelper;
use Themosis\Core\Validation\ValidatesRequests;
use Illuminate\Support\Facades\View;

class Controller extends BaseController
{
    use FormHelper, ValidatesRequests;

    public function __construct()
    {
        $this->site_vars = $this->get_sitevars();

        View::share('site_vars', $this->site_vars);
    }

    public function error404() {
        $this->site_vars = $this->get_sitevars();
        return view('errors.404', $this->site_vars);
    }

    private function get_sitevars() {
        $vars = [
            'logo' => get_field('settings_logo', 'option'),
            'contact' => get_field('settings_contact', 'option'),
            'social' => get_field('settings_social', 'option'),
            'footer' => get_field('settings_footer', 'option'),
            '404' => get_field('settings_404', 'option'),
            'vendor' => [
                'head' => get_field('settings_vendor_head', 'option'),
                'body' => get_field('settings_vendor_body', 'option'),
                'google_api' => get_field('settings_google_api_key', 'option')
            ]
        ];
      return $vars;
    }
}
